/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.KL7Sim;
import gui.Key;
import gui.OSName;
import gui.RndXtea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.regex.PatternSyntaxException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import kl7.Box;
import kl7.BoxMode;
import kl7.SavedState;
import net.miginfocom.swing.MigLayout;

public class KL7Codebook
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 5330030352361902411L;
    private JPanel contentPane;
    private DateType dT = DateType.MONTH;
    private boolean randGo = true;
    private StringBuffer s = new StringBuffer();
    private Calendar cal = null;
    private SecureRandom rnd = null;
    private static final String[] rName = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M"};
    private static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final String pattern = "^((([A-MP]=)([A-Z0-9]{36}))|(([01][0-9]=)([01]{36})))";
    private final String customFile = "kl7-custom.txt";
    private static final String[] nRingMark = new String[]{"A", "B", "B+", "C", "D", "E", "E+", "F", "G", "G+", "H", "I", "J", "J+", "K", "L", "M", "M+", "N", "O", "O+", "P", "Q", "R", "R+", "S", "T", "T+", "U", "V", "W", "W+", "X", "Y", "Z", "Z+"};
    static final String[] classification = new String[]{"CONFIDENTIAL", "RESTRICTED", "SECRET", "TOP SECRET"};
    private int[] nRings = new int[7];
    private int[] nPos = new int[7];
    private int[] sPos = new int[8];
    private String sSet = null;
    private String sCheck = null;
    private String fileName = null;
    private DateFormatSymbols dfs = null;
    private Box rbox = null;
    private JTextField netName;
    private JTextField passField;
    private JTextField dayField;
    private JTextField yearField;
    private JComboBox<String> monthField;
    private ButtonGroup selPeriod;
    private ButtonGroup selKeyGenMode;
    private static final String singleStr = "single";
    private static final String monthStr = "month";
    private static final String yearStr = "year";
    private static final String randStr = "rand";
    private static final String passStr = "pass";
    private static final String genStr = "gen";
    private static final String canStr = "ca";
    static final String testL = "LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL";
    private boolean fileSel = true;
    private final JFileChooser fc = new JFileChooser();
    private final TxtFilter tf = new TxtFilter();
    private File fo = null;
    private File oFil = null;
    private static boolean standAlone = false;
    private KL7Sim ksim;
    private SavedState savedSt;
    private JComboBox<String> comboBoxClass;
    private boolean useNewNRings = true;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    standAlone = true;
                    KL7Codebook frame = new KL7Codebook();
                    frame.setDefaultCloseOperation(3);
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        });
    }

    public KL7Codebook(Box b, KL7Sim ksim) {
        this();
        this.rbox = b;
        this.ksim = ksim;
        this.savedSt = new SavedState(b);
        this.savedSt.saveState();
    }

    public KL7Codebook() {
        try {
            if (!standAlone) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            } else {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            }
        }
        catch (Exception e) {
            System.err.println("Tough luck: " + e.toString());
            e.printStackTrace(System.err);
            System.exit(-2);
        }
        this.setResizable(false);
        this.setVisible(false);
        this.setDefaultCloseOperation(2);
        if (OSName.isMac()) {
            this.setBounds(10, 10, 350, 410);
            this.setPreferredSize(new Dimension(350, 410));
        } else if (OSName.isLinux()) {
            this.setBounds(10, 10, 350, 375);
            this.setPreferredSize(new Dimension(350, 375));
        } else {
            this.setBounds(10, 10, 350, 382);
            this.setPreferredSize(new Dimension(350, 382));
        }
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.cal = Calendar.getInstance();
        this.dfs = new DateFormatSymbols();
        JLabel lblKlCodebookGenerator = new JLabel("KL-7 Codebook Generator");
        lblKlCodebookGenerator.setBorder(new CompoundBorder(new EtchedBorder(1, null, null), new EmptyBorder(5, 5, 5, 5)));
        lblKlCodebookGenerator.setFont(new Font("Adobe Caslon Pro", 1, 17));
        this.contentPane.add((Component)lblKlCodebookGenerator, "North");
        JPanel panel = new JPanel();
        panel.setMaximumSize(new Dimension(350, 365));
        panel.setPreferredSize(new Dimension(350, 365));
        this.contentPane.add((Component)panel, "Center");
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel panelCodebook = new JPanel();
        panelCodebook.setMaximumSize(new Dimension(350, 250));
        panelCodebook.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), "Codebook", 4, 2, null, null));
        panel.add(panelCodebook);
        panelCodebook.setLayout((LayoutManager)new MigLayout("", "[92px][134px,grow][]", "[][28px][][][][][]"));
        JLabel lblClassification = new JLabel("Classification");
        lblClassification.setHorizontalAlignment(2);
        lblClassification.setAlignmentX(0.5f);
        panelCodebook.add((Component)lblClassification, "cell 0 0,alignx left");
        this.comboBoxClass = new JComboBox();
        panelCodebook.add(this.comboBoxClass, "cell 1 0,growx");
        this.comboBoxClass.setModel(new DefaultComboBoxModel<String>(classification));
        this.comboBoxClass.setSelectedIndex(0);
        JLabel lblCodenameNet = new JLabel("Codename Net");
        panelCodebook.add((Component)lblCodenameNet, "cell 0 1,alignx left,aligny center");
        this.netName = new JTextField();
        panelCodebook.add((Component)this.netName, "cell 1 1 2 1,alignx left,aligny top");
        this.netName.setColumns(25);
        this.netName.setText("ADONIS");
        UppercaseDocumentFilter filter = new UppercaseDocumentFilter();
        ((AbstractDocument)this.netName.getDocument()).setDocumentFilter(filter);
        JRadioButton rdbtnSingleKey = new JRadioButton("Single Key");
        rdbtnSingleKey.setActionCommand(singleStr);
        panelCodebook.add((Component)rdbtnSingleKey, "cell 0 2");
        this.dayField = new JTextField();
        panelCodebook.add((Component)this.dayField, "cell 1 2,alignx right");
        this.dayField.setColumns(2);
        this.dayField.setText(String.format("%2d", this.cal.get(5)));
        DigitFilter dayDocFlt = new DigitFilter(2);
        ((AbstractDocument)this.dayField.getDocument()).setDocumentFilter(dayDocFlt);
        JLabel lblDay = new JLabel("Day");
        panelCodebook.add((Component)lblDay, "cell 2 2");
        JRadioButton rdbtnOneMonth = new JRadioButton("One Month");
        rdbtnOneMonth.setActionCommand(monthStr);
        panelCodebook.add((Component)rdbtnOneMonth, "cell 0 3");
        this.monthField = new JComboBox();
        this.monthField.setModel(new DefaultComboBoxModel<String>(new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"}));
        this.monthField.setSelectedIndex(this.cal.get(2));
        panelCodebook.add(this.monthField, "cell 1 3,alignx right");
        JLabel lblMonth = new JLabel("Month");
        panelCodebook.add((Component)lblMonth, "cell 2 3");
        JRadioButton rdbtnWholeYear = new JRadioButton("Entire Year");
        rdbtnWholeYear.setActionCommand(yearStr);
        panelCodebook.add((Component)rdbtnWholeYear, "cell 0 4");
        this.yearField = new JTextField();
        this.yearField.setColumns(4);
        panelCodebook.add((Component)this.yearField, "cell 1 4,alignx right");
        JLabel lblYear = new JLabel("Year");
        panelCodebook.add((Component)lblYear, "cell 2 4");
        this.yearField.setText(String.format("%4d", this.cal.get(1)));
        DigitFilter yearDocFlt = new DigitFilter(4);
        ((AbstractDocument)this.yearField.getDocument()).setDocumentFilter(yearDocFlt);
        rdbtnOneMonth.setSelected(true);
        this.selPeriod = new ButtonGroup();
        this.selPeriod.add(rdbtnWholeYear);
        this.selPeriod.add(rdbtnOneMonth);
        this.selPeriod.add(rdbtnSingleKey);
        rdbtnWholeYear.addActionListener(this);
        rdbtnOneMonth.addActionListener(this);
        rdbtnSingleKey.addActionListener(this);
        this.yearField.setEnabled(true);
        this.monthField.setEnabled(true);
        this.dayField.setEnabled(false);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setActionCommand(canStr);
        btnCancel.addActionListener(this);
        panelCodebook.add((Component)btnCancel, "cell 0 6");
        JButton btnGenerate = new JButton("Generate");
        panelCodebook.add((Component)btnGenerate, "cell 1 6 2 1,alignx center");
        btnGenerate.setActionCommand(genStr);
        btnGenerate.addActionListener(this);
        JPanel panelMode = new JPanel();
        panelMode.setMinimumSize(new Dimension(350, 55));
        panelMode.setPreferredSize(new Dimension(350, 55));
        panelMode.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), "Key creation", 4, 2, null, null));
        panel.add(panelMode);
        panelMode.setLayout((LayoutManager)new MigLayout("", "[73px][grow]", "[][]"));
        JRadioButton rdbtnRandom = new JRadioButton("Random");
        rdbtnRandom.setActionCommand(randStr);
        panelMode.add((Component)rdbtnRandom, "cell 0 0,alignx left,aligny top");
        rdbtnRandom.addActionListener(this);
        JRadioButton rdbtnWithPassword = new JRadioButton("From password");
        rdbtnWithPassword.setActionCommand(passStr);
        panelMode.add((Component)rdbtnWithPassword, "cell 0 1");
        rdbtnWithPassword.addActionListener(this);
        this.selKeyGenMode = new ButtonGroup();
        this.selKeyGenMode.add(rdbtnRandom);
        this.selKeyGenMode.add(rdbtnWithPassword);
        rdbtnRandom.setSelected(true);
        this.passField = new JTextField();
        panelMode.add((Component)this.passField, "cell 1 1,growx");
        this.passField.setColumns(30);
        this.passField.setEnabled(false);
        this.cal = Calendar.getInstance();
        this.dfs = new DateFormatSymbols();
        if (standAlone) {
            this.rbox = new Box();
            this.savedSt = new SavedState(this.rbox);
            File cust = new File("kl7-custom.txt");
            if (cust.exists() && cust.isFile() && cust.canRead()) {
                this.doCustomization(cust);
            }
        }
    }

    public void setNewBox(Box b) {
        this.rbox = b;
        this.savedSt = new SavedState(this.rbox);
    }

    private void exit(int code) {
        if (!standAlone) {
            this.passField.setText("");
            this.netName.setText("ADONIS");
            this.setFocusableWindowState(false);
            this.setFocusable(false);
            this.setVisible(false);
            this.ksim.reqFoc();
            return;
        }
        System.exit(code);
    }

    public void enableBook() {
        this.setFocusableWindowState(true);
        this.setFocusable(true);
        this.setVisible(true);
        this.netName.setEnabled(true);
        this.netName.setEditable(true);
        this.passField.setEditable(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(canStr)) {
            this.exit(0);
        }
        if (cmd.equals(singleStr)) {
            this.dayField.setEnabled(true);
            this.monthField.setEnabled(true);
            this.yearField.setEnabled(true);
            this.dT = DateType.DAY;
            return;
        }
        if (cmd.equals(monthStr)) {
            this.dayField.setEnabled(false);
            this.monthField.setEnabled(true);
            this.yearField.setEnabled(true);
            this.dT = DateType.MONTH;
            return;
        }
        if (cmd.equals(yearStr)) {
            this.dayField.setEnabled(false);
            this.monthField.setEnabled(false);
            this.yearField.setEnabled(true);
            this.dT = DateType.YEAR;
            return;
        }
        if (cmd.equals(randStr)) {
            this.rnd = new SecureRandom();
            this.passField.setEnabled(false);
            this.randGo = true;
            return;
        }
        if (cmd.equals(passStr)) {
            this.passField.setEnabled(true);
            this.randGo = false;
            return;
        }
        if (cmd.equals(genStr)) {
            this.fileSel = true;
            if (this.generate()) {
                String sst = this.dT == DateType.DAY || this.dT == DateType.MONTH ? " file " : " files with base name ";
                if (this.fo != null) {
                    sst = String.valueOf(sst) + this.fo.getName() + "/";
                }
                sst = this.dT == DateType.DAY || this.dT == DateType.MONTH ? String.valueOf(sst) + this.fileName : String.valueOf(sst) + this.netName.getText() + "*.txt";
                JOptionPane.showMessageDialog(null, "Codebook generated  succesfully, and written to " + sst, "CODEBOOK GENERATED", 1);
                this.exit(0);
            } else {
                if (this.fileSel) {
                    JOptionPane.showMessageDialog(null, "Could not generate keys! Probably some fields were not filled?", "SERIOUS ERROR", 0);
                }
                return;
            }
        }
        this.exit(-1);
    }

    boolean generate() {
        boolean retcode = false;
        if (this.randGo) {
            this.rnd = new SecureRandom();
        } else {
            String pass = this.passField.getText();
            if (pass.length() <= 0) {
                JOptionPane.showMessageDialog(null, "If you want to generate keys based on password - type the password in first!", "ERROR", 0);
                return false;
            }
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-512");
                md.update(pass.getBytes());
                md.update("codebooking".getBytes());
                md.update("WVnHB$%^8(!6vcPSZ".getBytes());
                byte[] digest = md.digest();
                this.rnd = new RndXtea();
                this.rnd.setSeed(digest);
            }
            catch (NoSuchAlgorithmException cex2) {
                cex2.printStackTrace();
                JOptionPane.showMessageDialog(null, "Could not generate pseudorandom seed from given password - Sha512 not supported...", "SERIOUS ERROR", 0);
                return false;
            }
        }
        this.fc.setFileFilter(this.tf);
        this.fc.setFileSelectionMode(1);
        int result = this.fc.showSaveDialog(null);
        switch (result) {
            case 0: {
                this.fo = this.fc.getSelectedFile();
                this.fileSel = true;
                break;
            }
            case 1: {
                this.fo = null;
                this.fileSel = false;
                return false;
            }
            default: {
                this.fo = null;
                return false;
            }
        }
        this.savedSt.saveState();
        this.useNewNRings = true;
        switch (this.dT) {
            case DAY: {
                String st = this.dayField.getText().trim();
                if (st == null || st.length() > 2 || !st.matches("\\d{1,2}")) {
                    System.err.println("Day field not filed or wrong format! " + st);
                    return false;
                }
                int day = Integer.parseInt(st);
                int month = this.monthField.getSelectedIndex() + 1;
                st = this.yearField.getText();
                int year = Integer.parseInt(st);
                if (year < 0 || year > 3000) {
                    return false;
                }
                this.cal.set(2, month - 1);
                this.cal.set(1, year);
                if (day > this.cal.getActualMaximum(5)) {
                    JOptionPane.showMessageDialog(null, "This month does not have so many days! " + day + " instead of " + this.cal.getActualMaximum(5), "SERIOUS ERROR", 0);
                    return false;
                }
                st = this.netName.getText().trim();
                if (st.length() == 0) {
                    st = "ADONIS";
                }
                this.printSingleKey(this.fo, st, day, month, year);
                retcode = true;
                break;
            }
            case MONTH: {
                int month = this.monthField.getSelectedIndex() + 1;
                String st = this.yearField.getText().trim();
                int year = Integer.parseInt(st);
                if (year < 0 || year > 3000) {
                    return false;
                }
                this.cal.set(2, month - 1);
                this.cal.set(1, year);
                st = this.netName.getText().trim();
                if (st.length() == 0) {
                    st = "ADONIS";
                }
                this.printMonth(this.fo, st, month, year);
                retcode = true;
                break;
            }
            case YEAR: {
                String st = this.yearField.getText().trim();
                int year = Integer.parseInt(st);
                if (year < 0 || year > 3000) {
                    return false;
                }
                st = this.netName.getText().trim();
                if (st.length() == 0) {
                    st = "ADONIS";
                }
                this.printYear(this.fo, st, year);
                retcode = true;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "None of the date options were selected?! Can't be...", "SERIOUS ERROR", 0);
            }
        }
        this.savedSt.restoreState();
        return retcode;
    }

    String genRotors(Key key) {
        this.s.delete(0, this.s.length());
        int[] rots = new int[rName.length];
        int i = 0;
        while (i < rName.length) {
            rots[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 8) {
            int k = this.rnd.nextInt(rName.length);
            while (rots[k] != -1) {
                k = (k + 1) % rName.length;
            }
            key.rotors[i] = rName[k];
            rots[k] = i;
            this.s.append(rName[k]);
            this.rbox.setRotor(rName[k], i);
            ++i;
        }
        return this.s.toString();
    }

    void genNRings(Key key) {
        int[] rings = new int[11];
        int i = 0;
        while (i < 11) {
            rings[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 7) {
            int k = this.rnd.nextInt(11);
            while (rings[k] != -1) {
                k = (k + 1) % 11;
            }
            rings[k] = i;
            this.nRings[i] = k + 1;
            this.rbox.setNRing(i, k);
            key.nrings[i] = this.nRings[i];
            ++i;
        }
    }

    void genRSPos(Key key) {
        int i = 0;
        while (i < 8) {
            this.sPos[i] = this.rnd.nextInt(36) + 1;
            this.rbox.setRotorStart(i, (byte)(this.sPos[i] - 1));
            key.offsets[i] = this.sPos[i];
            ++i;
        }
    }

    void genNSPos(Key key) {
        int i = 0;
        while (i < 7) {
            this.nPos[i] = this.rnd.nextInt(36) + 1;
            this.rbox.setNRingPos(i, this.nPos[i] - 1);
            key.noffs[i] = this.nPos[i];
            ++i;
        }
    }

    void genSSet(Key key) {
        this.s.delete(0, this.s.length());
        int i = 0;
        while (i < 7) {
            int k = this.rnd.nextInt(26);
            this.s.append(alphabet.charAt(k));
            ++i;
        }
        this.sSet = this.s.toString();
        key.bStart = this.s.toString();
    }

    void genSysInd(Key key) {
        int k;
        StringBuffer chInd = new StringBuffer(5);
        int i = 0;
        while (i < 5) {
            k = this.rnd.nextInt(26) + 65;
            chInd.append(Character.toChars(k));
            ++i;
        }
        key.sysInd[0] = chInd.toString();
        chInd.delete(0, 5);
        i = 0;
        while (i < 4) {
            k = this.rnd.nextInt(10);
            chInd.append(String.format("%1d", k));
            ++i;
        }
        key.sysInd[1] = chInd.toString();
    }

    void genSCheck(Key key) {
        this.setBox(this.rbox, key);
        this.rbox.setBoxMode(BoxMode.P);
        this.rbox.setMsgKey("AAAAAAA");
        this.rbox.setBoxMode(BoxMode.E);
        String out = this.rbox.encryptString(testL);
        int i = out.lastIndexOf(32, 45);
        this.sCheck = out.substring(i).trim();
        key.checksum[0] = this.sCheck.substring(0, 6).trim();
        i = this.sCheck.indexOf(32);
        key.checksum[1] = this.sCheck.substring(i + 1).trim();
    }

    void setBox(Box b, Key key) {
        b.setBox(key);
    }

    void printSingleKey(File fBase, String net, int day, int mon, int year) {
        PrintWriter pout = null;
        Key key = new Key();
        key.setNewNRings(this.useNewNRings);
        String month = this.dfs.getShortMonths()[mon - 1];
        String date = String.format("%2d-%3s-%4d ", day, month, year);
        this.fileName = String.valueOf(net) + String.format(" %04d-%02d-%02d.txt", year, mon, day);
        try {
            this.oFil = fBase != null ? new File(fBase, this.fileName) : new File(this.fileName);
            pout = new PrintWriter(this.oFil);
        }
        catch (FileNotFoundException ex1) {
            String str = fBase == null ? "null\"" : String.valueOf(fBase.getName()) + "\"";
            System.err.println("Cannot open/create file \"" + this.fileName + "\" " + "in directory \" - printing to stdout..." + str);
            pout = new PrintWriter(System.out);
        }
        pout.print(" +----------------------------------------------");
        pout.print("----------");
        pout.println("-------------+");
        pout.print(" | ");
        String clsf = (String)this.comboBoxClass.getSelectedItem();
        int i = 41 - net.length() - date.length() - clsf.length();
        if (i < 0) {
            pout.print(String.valueOf(net.substring(0, net.length() + i)) + " ");
        } else {
            pout.print(clsf);
            pout.print(" ");
            int k = i / 2;
            i -= k;
            while (k-- > 0) {
                pout.print(" ");
            }
            pout.print(net);
            while (i-- > 0) {
                pout.print(" ");
            }
        }
        pout.print(date.toUpperCase());
        pout.print("|  1  2  3  4  5  6  7  8 |");
        pout.println();
        pout.print(" |-------------------------------------------+--------------------");
        pout.print("-----|");
        pout.println();
        this.savedSt.restoreState();
        pout.print(" | ROTOR                                     |");
        String s = this.genRotors(key);
        i = 0;
        while (i < 8) {
            pout.print("  " + s.charAt(i));
            ++i;
        }
        pout.println(" |");
        pout.print(" | ROTOR ALPHABET POSITION                   |");
        this.genRSPos(key);
        i = 0;
        while (i < 8) {
            pout.print(String.format(" %02d", this.sPos[i]));
            ++i;
        }
        pout.println(" |");
        pout.print(" | NOTCH RING                                |");
        this.genNRings(key);
        i = 0;
        while (i < 3) {
            pout.print(String.format(" %2d", this.nRings[i]));
            ++i;
        }
        pout.print("   ");
        i = 3;
        while (i < 7) {
            pout.print(String.format(" %2d", this.nRings[i]));
            ++i;
        }
        pout.println(" |");
        pout.print(" | NOTCH RING POSITION                       |");
        this.genNSPos(key);
        if (this.useNewNRings) {
            i = 0;
            while (i < 3) {
                pout.print(String.format(" %2s", nRingMark[this.nPos[i] - 1]));
                ++i;
            }
            pout.print("   ");
            i = 3;
            while (i < 7) {
                pout.print(String.format(" %2s", nRingMark[this.nPos[i] - 1]));
                ++i;
            }
        } else {
            i = 0;
            while (i < 3) {
                pout.print(String.format(" %02d", this.nPos[i]));
                ++i;
            }
            pout.print("   ");
            i = 3;
            while (i < 7) {
                pout.print(String.format(" %02d", this.nPos[i]));
                ++i;
            }
        }
        pout.println(" |");
        pout.print(" | DAILY ROTOR ALIGNMENT                     |");
        this.genSSet(key);
        i = 0;
        while (i < 3) {
            pout.print("  " + this.sSet.charAt(i));
            ++i;
        }
        pout.print("   ");
        i = 3;
        while (i < 7) {
            pout.print("  " + this.sSet.charAt(i));
            ++i;
        }
        pout.println(" |");
        pout.print(" |-------------------------------------------+-----------");
        pout.println("--------------|");
        pout.print(" | SYSTEM INDICATOR                          |");
        this.genSysInd(key);
        pout.print(" ");
        pout.print(key.getCharIndicator());
        pout.print(" ");
        pout.print(key.getNumIndicator());
        pout.println("              |");
        pout.print(" |-------------------------------------------+-----------");
        pout.println("--------------|");
        pout.print(" | 36-45 LETTER CHECK                        |");
        this.genSCheck(key);
        pout.print(" ");
        pout.print(this.sCheck);
        pout.print(" ");
        pout.println("            |");
        pout.print(" +--------------------------------------------");
        pout.println("-------------------------+");
        pout.flush();
        pout.close();
        this.savedSt.restoreState();
    }

    void printHeader(PrintWriter pout) {
        pout.println(" -----------------------------------------------------------------------------------------");
        pout.println(" | DAY|          ROTORS         |      NOTCH RINGS     |DAILY ROTOR| 36-45 LTR |  SYSTEM |");
        pout.println(" |    |  1  2  3  4  5  6  7  8 |  1  2  3  5  6  7  8 | ALIGNMENT | CHECK GRP |INDICATOR|");
        pout.println(" |----+-------------------------+----------------------+-----------+-----------+---------|");
    }

    void printDay(int day, PrintWriter pout) {
        int i = 0;
        StringBuffer s = new StringBuffer();
        Key key = new Key();
        if (this.useNewNRings) {
            key.setNewNRings(true);
        } else {
            key.setNewNRings(false);
        }
        pout.print(" | " + String.format("%2d", day) + " |");
        this.savedSt.restoreState();
        String si = this.genRotors(key);
        i = 0;
        while (i < 8) {
            s.append("  ");
            s.append(si.charAt(i));
            ++i;
        }
        s.append(" ");
        pout.print(s.toString());
        s.delete(0, s.length());
        pout.print("|");
        this.genRSPos(key);
        this.genNRings(key);
        i = 0;
        while (i < 7) {
            si = String.format(" %2d", this.nRings[i]);
            s.append(si);
            ++i;
        }
        pout.print(s.toString());
        s.delete(0, s.length());
        this.genNSPos(key);
        this.genSSet(key);
        pout.print(" | ");
        i = 0;
        while (i < 3) {
            s.append(this.sSet.charAt(i));
            ++i;
        }
        s.append(" ");
        i = 3;
        while (i < 7) {
            s.append(this.sSet.charAt(i));
            ++i;
        }
        s.append(" ");
        pout.print(s.toString());
        s.delete(0, s.length());
        this.genSCheck(key);
        pout.print(" |");
        pout.print(String.valueOf(this.sCheck) + "|");
        this.genSysInd(key);
        pout.print("  ");
        pout.print(key.sysInd[0]);
        pout.println("  |");
        pout.print(" |    |");
        this.savedSt.restoreState();
        i = 0;
        while (i < 8) {
            s.append(String.format(" %02d", this.sPos[i]));
            ++i;
        }
        pout.print(s.toString());
        s.delete(0, s.length());
        pout.print(" |");
        if (this.useNewNRings) {
            i = 0;
            while (i < 7) {
                s.append(String.format(" %2s", nRingMark[this.nPos[i] - 1]));
                ++i;
            }
        } else {
            i = 0;
            while (i < 7) {
                s.append(String.format(" %02d", this.nPos[i]));
                ++i;
            }
        }
        pout.print(s.toString());
        s.delete(0, s.length());
        pout.print(" |          ");
        pout.print(" |           |");
        pout.println("  " + key.sysInd[1] + " " + "  |");
    }

    String getMonthName(int mon) {
        if (mon < 1 || mon > 12) {
            mon = 9;
        }
        return this.dfs.getMonths()[mon - 1];
    }

    void printMonthTitle(String net, int month, int year, PrintWriter pout) {
        String sOut;
        int LENGTH;
        int len = LENGTH = 90;
        Key key = new Key();
        this.genSysInd(key);
        String sBeg = " " + (String)this.comboBoxClass.getSelectedItem() + " CRYPTO";
        String sEnd = this.getMonthName(month);
        sEnd = sEnd.toUpperCase();
        sEnd = String.valueOf(sEnd) + String.format(" %4d", year);
        len -= sEnd.length() + sBeg.length();
        String sMid = net;
        sMid = String.valueOf(sMid) + " ";
        sMid = String.valueOf(sMid) + key.getNumIndicator();
        sMid = String.valueOf(sMid) + " ";
        sMid = String.valueOf(sMid) + key.getCharIndicator();
        if (sMid.length() >= len - 1) {
            sMid = " " + sMid.substring(0, len - 2) + " ";
            sOut = String.valueOf(sBeg) + sMid + sEnd;
        } else {
            int k = sBeg.length() > sEnd.length() ? sBeg.length() : sEnd.length();
            k = LENGTH / 2 - k;
            StringBuffer fill = new StringBuffer();
            int j = k;
            while (j > 0) {
                fill.append(" ");
                --j;
            }
            sMid = fill + sMid;
            len -= sMid.length();
            len += LENGTH % 2;
            fill.delete(0, fill.length());
            while (len-- > 0) {
                fill.append(" ");
            }
            sMid = String.valueOf(sMid) + fill;
            sOut = String.valueOf(sBeg) + sMid + sEnd;
        }
        pout.println(sOut);
        pout.println();
    }

    void printMonth(File fBase, String net, int month, int year) {
        if (month < 1 || month > 12 || year < 0 || year > 2500) {
            return;
        }
        this.cal = Calendar.getInstance();
        this.cal.set(1, year);
        this.cal.set(2, month - 1);
        int i = this.cal.getActualMaximum(5);
        this.fileName = String.valueOf(net) + String.format(" %04d-%02d.txt", year, month);
        PrintWriter pout = null;
        try {
            this.oFil = fBase != null ? new File(fBase, this.fileName) : new File(this.fileName);
            pout = new PrintWriter(this.oFil);
        }
        catch (FileNotFoundException ex1) {
            String str = fBase == null ? "null\"" : String.valueOf(fBase.getName()) + "\"";
            System.err.println("Cannot open/create file \"" + this.fileName + "\" " + "in directory \" - sending to stdout..." + str);
            pout = new PrintWriter(System.out);
        }
        this.printMonthTitle(net.toUpperCase(), month, year, pout);
        this.printHeader(pout);
        while (i > 0) {
            this.printDay(i, pout);
            --i;
        }
        pout.println(" -----------------------------------------------------------------------------------------");
        pout.flush();
        pout.close();
    }

    void printYear(File fBase, String net, int year) {
        int i = 1;
        while (i <= 12) {
            this.printMonth(fBase, net, i, year);
            ++i;
        }
    }

    void test() {
        this.cal.set(1, 2012);
        this.printSingleKey(null, "ADONIS", 9, 9, 2012);
    }

    /*
     * Exception decompiling
     */
    private void doCustomization(File inf) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 31[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void addTitle(String s) {
        String ss = s.substring(0, 2);
        if (!ss.equals("T=")) {
            return;
        }
        ss = s.substring(2);
        if (ss.indexOf("=") != -1) {
            return;
        }
    }

    void addCustomPlate(String s) {
        if (!s.startsWith("P=")) {
            return;
        }
        this.rbox.setCustomBasePlate(s.substring(2));
    }

    void addCustomRotor(String s) {
        int i = s.indexOf(61);
        if (i != 1 || s.substring(2).indexOf("=") != -1) {
            return;
        }
        this.rbox.setCustomRotor(s.substring(0, 1), s.substring(2));
    }

    void addCustomNotchedRing(String s) {
        int i = s.indexOf(61);
        if (i != 2) {
            return;
        }
        int ring = Integer.parseInt(s.substring(0, 2));
        this.rbox.setCustomNRing(ring, s.substring(3));
    }

    static enum CLS {
        CONF,
        RES,
        SEC,
        TS;

    }

    private static enum DateType {
        DAY,
        MONTH,
        YEAR;

    }

    private class DigitFilter
    extends DocumentFilter {
        final int size;

        public DigitFilter(int num) {
            this.size = num;
            StringBuffer s = new StringBuffer();
            while (num-- > 0) {
                s.append("\\d");
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) {
            try {
                int len = text.length();
                if (len <= this.size && len > 0) {
                    if (Character.isDigit(text.charAt(len - 1))) {
                        fb.insertString(offset, text, attr);
                    } else {
                        JOptionPane.showMessageDialog(null, "Please Enter a valid Integer Value - " + this.size + " digits.", "Invalid Input : ", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Please Enter a valid Integer Value - " + this.size + " digits.", "Invalid Input : ", 0);
                }
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
            try {
                int len = text.length();
                if (len <= this.size && len > 0) {
                    if (Character.isDigit(text.charAt(len - 1))) {
                        fb.replace(offset, length, text, attrs);
                    } else {
                        JOptionPane.showMessageDialog(null, "Please Enter a valid Integer Value - " + this.size + " digits.", "Invalid Input : ", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Please Enter a valid Integer Value - " + this.size + " digits.", "Invalid Input : ", 0);
                }
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    private class TxtFilter
    extends FileFilter {
        private TxtFilter() {
        }

        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            return file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "dir";
        }
    }

    private class UppercaseDocumentFilter
    extends DocumentFilter {
        String newText = "";

        private UppercaseDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) {
            try {
                text = this.newText = text.replaceAll("[^a-zA-Z0-9\\s-_]", " ");
                fb.insertString(offset, text.toUpperCase(), attr);
            }
            catch (PatternSyntaxException ex) {
                ex.printStackTrace();
            }
            catch (BadLocationException ex1) {
                ex1.printStackTrace();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
            try {
                text = this.newText = text.replaceAll("[^a-zA-Z0-9\\s-_]", " ");
                fb.replace(offset, length, text.toUpperCase(), attrs);
            }
            catch (PatternSyntaxException ex) {
                ex.printStackTrace();
            }
            catch (BadLocationException ex1) {
                ex1.printStackTrace();
            }
        }
    }
}

