/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import gui.KL7Sim;
import gui.OSName;
import gui.RndXtea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class KL7Rewire
extends JFrame {
    private static final long serialVersionUID = 3008677950798148892L;
    private static final String pwKey = "pwKey";
    private static final String rndKey = "rndKey";
    private JPanel contentPane;
    private JTextField txtKlCustomSettings;
    private final JFileChooser fc = new JFileChooser();
    private final TxtFilter tf = new TxtFilter();
    private JCheckBox[] rotCB;
    private JCheckBox[] notchCB;
    private JCheckBox plateCB;
    final String CUSTOM_FILE = "kl7-custom.txt";
    static final String[] rName = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M"};
    private final String[] nName = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11"};
    private final String rotInd = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private SecureRandom rnd = null;
    private ButtonGroup keyGenMode;
    private JTextField passField;
    private JRadioButton rndBtn;
    private JRadioButton pwBtn;
    private boolean standAlone = false;
    private KL7Sim ksim;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    KL7Rewire frame = new KL7Rewire();
                    frame.standAlone = true;
                    frame.setDefaultCloseOperation(3);
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public KL7Rewire(KL7Sim ksim) {
        this();
        this.ksim = ksim;
    }

    public KL7Rewire() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            System.err.println("Tough luck: " + e.toString());
            e.printStackTrace(System.err);
            System.exit(-2);
        }
        this.setTitle("KL-7 Customization");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        if (OSName.isMac()) {
            this.setBounds(10, 10, 440, 365);
            this.setPreferredSize(new Dimension(440, 365));
        } else if (OSName.isLinux()) {
            this.setBounds(10, 10, 440, 375);
            this.setPreferredSize(new Dimension(440, 375));
        } else {
            this.setBounds(10, 10, 440, 394);
            this.setPreferredSize(new Dimension(440, 394));
        }
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "North");
        panel.setLayout(new BoxLayout(panel, 0));
        JLabel lblCustomizingKl = new JLabel("Customizing KL-7");
        lblCustomizingKl.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        lblCustomizingKl.setLocation(new Point(50, 0));
        lblCustomizingKl.setHorizontalTextPosition(0);
        panel.add(lblCustomizingKl);
        lblCustomizingKl.setHorizontalAlignment(0);
        lblCustomizingKl.setFont(new Font("Lucida Blackletter", 1, 26));
        JLabel lblCreatingCustomrewired = new JLabel("<html><body>Custom/rewired rotors, <br> notched rings, baseplate.</body></html>");
        lblCreatingCustomrewired.setVerticalTextPosition(3);
        lblCreatingCustomrewired.setVerticalAlignment(3);
        lblCreatingCustomrewired.setFont(new Font("Gill Sans MT", 0, 12));
        lblCreatingCustomrewired.setPreferredSize(new Dimension(150, 40));
        lblCreatingCustomrewired.setMinimumSize(new Dimension(101, 40));
        lblCreatingCustomrewired.setAlignmentX(0.5f);
        lblCreatingCustomrewired.setMaximumSize(new Dimension(200, 40));
        lblCreatingCustomrewired.setBorder(new EmptyBorder(12, 16, 10, 0));
        panel.add(lblCreatingCustomrewired);
        JPanel panel_1 = new JPanel();
        panel_1.setPreferredSize(new Dimension(440, 320));
        panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Components to modify/rewire", 4, 2, null, Color.DARK_GRAY));
        this.contentPane.add((Component)panel_1, "Center");
        panel_1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblTitle = new JLabel("Title:");
        lblTitle.setFont(new Font("Palatino", 3, 14));
        lblTitle.setHorizontalTextPosition(4);
        lblTitle.setHorizontalAlignment(4);
        panel_1.add((Component)lblTitle, "2, 2");
        this.txtKlCustomSettings = new JTextField();
        this.txtKlCustomSettings.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.txtKlCustomSettings.setText("Custom Settings");
        panel_1.add((Component)this.txtKlCustomSettings, "4, 2, 13, 1, fill, center");
        this.txtKlCustomSettings.setColumns(10);
        CustDocFilter filter = new CustDocFilter();
        ((AbstractDocument)this.txtKlCustomSettings.getDocument()).setDocumentFilter(filter);
        JLabel lblRotors = new JLabel("Rotors:");
        lblRotors.setFont(new Font("Palatino", 3, 14));
        lblRotors.setHorizontalTextPosition(4);
        lblRotors.setHorizontalAlignment(4);
        panel_1.add((Component)lblRotors, "2, 6");
        this.rotCB = new JCheckBox[13];
        this.notchCB = new JCheckBox[11];
        this.rotCB[0] = new JCheckBox("A");
        panel_1.add((Component)this.rotCB[0], "4, 6");
        this.rotCB[1] = new JCheckBox("B");
        panel_1.add((Component)this.rotCB[1], "6, 6");
        this.rotCB[2] = new JCheckBox("C");
        panel_1.add((Component)this.rotCB[2], "8, 6");
        this.rotCB[3] = new JCheckBox("D");
        panel_1.add((Component)this.rotCB[3], "10, 6");
        this.rotCB[4] = new JCheckBox("E");
        panel_1.add((Component)this.rotCB[4], "12, 6");
        this.rotCB[5] = new JCheckBox("F");
        this.rotCB[5].setBounds(0, 0, 20, 20);
        panel_1.add((Component)this.rotCB[5], "14, 6");
        this.rotCB[6] = new JCheckBox("G");
        panel_1.add((Component)this.rotCB[6], "16, 6");
        this.rotCB[7] = new JCheckBox("H");
        panel_1.add((Component)this.rotCB[7], "4, 8");
        this.rotCB[8] = new JCheckBox("I");
        panel_1.add((Component)this.rotCB[8], "6, 8");
        this.rotCB[9] = new JCheckBox("J");
        panel_1.add((Component)this.rotCB[9], "8, 8");
        this.rotCB[10] = new JCheckBox("K");
        panel_1.add((Component)this.rotCB[10], "10, 8");
        this.rotCB[11] = new JCheckBox("L");
        panel_1.add((Component)this.rotCB[11], "12, 8");
        this.rotCB[12] = new JCheckBox("M");
        panel_1.add((Component)this.rotCB[12], "14, 8");
        JLabel lblNotched = new JLabel("<html>Notched <br>rings:</html>");
        lblNotched.setVerticalTextPosition(1);
        lblNotched.setVerticalAlignment(1);
        lblNotched.setFont(new Font("Palatino", 3, 14));
        lblNotched.setHorizontalTextPosition(4);
        lblNotched.setHorizontalAlignment(4);
        panel_1.add((Component)lblNotched, "1, 12, 2, 4, default, top");
        this.notchCB[0] = new JCheckBox("1");
        panel_1.add((Component)this.notchCB[0], "4, 12");
        this.notchCB[1] = new JCheckBox("2");
        panel_1.add((Component)this.notchCB[1], "6, 12");
        this.notchCB[2] = new JCheckBox("3");
        panel_1.add((Component)this.notchCB[2], "8, 12");
        this.notchCB[3] = new JCheckBox("4");
        panel_1.add((Component)this.notchCB[3], "10, 12");
        this.notchCB[4] = new JCheckBox("5");
        panel_1.add((Component)this.notchCB[4], "12, 12");
        this.notchCB[5] = new JCheckBox("6");
        panel_1.add((Component)this.notchCB[5], "14, 12");
        this.notchCB[6] = new JCheckBox("7");
        panel_1.add((Component)this.notchCB[6], "4, 14");
        this.notchCB[7] = new JCheckBox("8");
        panel_1.add((Component)this.notchCB[7], "6, 14");
        this.notchCB[8] = new JCheckBox("9");
        panel_1.add((Component)this.notchCB[8], "8, 14");
        this.notchCB[9] = new JCheckBox("10");
        panel_1.add((Component)this.notchCB[9], "10, 14");
        this.notchCB[10] = new JCheckBox("11");
        panel_1.add((Component)this.notchCB[10], "12, 14");
        JLabel lblBaseplate = new JLabel("BasePlate:");
        lblBaseplate.setHorizontalAlignment(4);
        lblBaseplate.setFont(new Font("Palatino", 3, 14));
        panel_1.add((Component)lblBaseplate, "2, 18");
        this.plateCB = new JCheckBox("Baseplate");
        panel_1.add((Component)this.plateCB, "4, 18, 9, 1");
        this.rndBtn = new JRadioButton("Random");
        this.rndBtn.setActionCommand(rndKey);
        this.rndBtn.addActionListener(new ButtonHandler(ButtType.RND));
        panel_1.add((Component)this.rndBtn, "2, 20");
        this.pwBtn = new JRadioButton("From password");
        this.pwBtn.setActionCommand(pwKey);
        this.pwBtn.addActionListener(new ButtonHandler(ButtType.PWD));
        panel_1.add((Component)this.pwBtn, "2, 22");
        this.passField = new JTextField();
        panel_1.add((Component)this.passField, "4, 22, 13, 1");
        this.keyGenMode = new ButtonGroup();
        this.keyGenMode.add(this.rndBtn);
        this.keyGenMode.add(this.pwBtn);
        this.rndBtn.setSelected(true);
        this.passField.setEnabled(false);
        JPanel panel_2 = new JPanel();
        this.contentPane.add((Component)panel_2, "South");
        JButton btnCancel = new JButton("Cancel");
        panel_2.add(btnCancel);
        btnCancel.addActionListener(new ButtonHandler(ButtType.CANCEL));
        JButton btnSave = new JButton("Generate");
        panel_2.add(btnSave);
        btnSave.addActionListener(new ButtonHandler(ButtType.GEN));
    }

    private void zeroize() {
        int i = 0;
        while (i < 13) {
            this.rotCB[i].setSelected(false);
            if (i < 11) {
                this.notchCB[i].setSelected(false);
            }
            ++i;
        }
        this.plateCB.setSelected(false);
        this.txtKlCustomSettings.setText("Custom Settings");
    }

    private void exit(int code) {
        if (!this.standAlone) {
            this.zeroize();
            this.setVisible(false);
            this.ksim.reqFoc();
            return;
        }
        System.exit(code);
    }

    private boolean generateCustomSettings() {
        File fo;
        block25: {
            boolean change = false;
            PrintWriter prout = null;
            fo = null;
            change = false;
            int i = 0;
            while (i < 13) {
                if (this.rotCB[i].isSelected()) {
                    change = true;
                    break;
                }
                if (i < 11) {
                    if (this.notchCB[i].isSelected()) {
                        change = true;
                        break;
                    }
                    if (this.plateCB.isSelected()) {
                        change = true;
                    }
                }
                ++i;
            }
            if (!change) {
                JOptionPane.showMessageDialog(null, "Nothing to generate -  nothing selected!", "Empty selection", 2);
                return false;
            }
            if (this.pwBtn.isSelected()) {
                String pass = this.passField.getText();
                if (pass.length() <= 0) {
                    JOptionPane.showMessageDialog(null, "If you want to generate new wiring based on password - type the password in first!", "ERROR", 0);
                    return false;
                }
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-512");
                    md.update(pass.getBytes());
                    md.update("rewiring".getBytes());
                    md.update("YRWPI&!LEJOU".getBytes());
                    byte[] digest = md.digest();
                    this.rnd = new RndXtea();
                    this.rnd.setSeed(digest);
                }
                catch (NoSuchAlgorithmException excep5) {
                    System.err.println("Could not create MessageDigest with SHA512! ");
                    return false;
                }
            } else {
                this.rnd = new SecureRandom();
            }
            this.fc.setFileFilter(this.tf);
            this.fc.setAcceptAllFileFilterUsed(false);
            int result = this.fc.showSaveDialog(this.contentPane);
            switch (result) {
                case 0: {
                    fo = this.fc.getSelectedFile();
                    break;
                }
                case 1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            try {
                try {
                    String fname = fo.getName();
                    if (!fname.endsWith(".txt")) {
                        fname = String.valueOf(fname) + ".txt";
                        fo = new File(fname);
                    }
                    prout = new PrintWriter(fo);
                    this.outputTitle(prout);
                    this.outputRotors(prout);
                    if (this.plateCB.isSelected()) {
                        prout.println("P=" + this.genPlate());
                    }
                    this.outputNotches(prout);
                }
                catch (IOException ex8) {
                    JOptionPane.showMessageDialog(null, "Could not save to file \"" + fo.getName() + "\" " + ex8.getMessage(), "Error writing file", 0);
                    ex8.printStackTrace();
                    if (prout != null) {
                        prout.close();
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (prout != null) {
                    prout.close();
                }
                throw throwable;
            }
            if (prout != null) {
                prout.close();
            }
        }
        JOptionPane.showMessageDialog(null, "Saved generated configuration in \"" + fo.getName() + "\"", "Generated new rotors, etc", 1);
        return true;
    }

    private void outputTitle(PrintWriter po) {
        String s = this.txtKlCustomSettings.getText();
        if (s.length() > 0) {
            po.println("T=" + s);
        }
    }

    private void outputRotors(PrintWriter po) {
        int i = 0;
        while (i < 13) {
            if (this.rotCB[i].isSelected()) {
                String s = this.genRotor();
                po.println(String.valueOf(rName[i]) + "=" + s);
            }
            ++i;
        }
    }

    private void outputNotches(PrintWriter po) {
        int i = 0;
        while (i < 11) {
            if (this.notchCB[i].isSelected()) {
                String s = this.genNotch();
                po.println(String.valueOf(this.nName[i]) + "=" + s);
            }
            ++i;
        }
    }

    private String genRotor() {
        StringBuffer rs = new StringBuffer();
        int rand = 0;
        int i = 0;
        char[] symbols = new char[36];
        i = 0;
        while (i < 36) {
            symbols[i] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".charAt(i);
            ++i;
        }
        i = 0;
        while (i < 36) {
            rand = this.rnd.nextInt(36);
            while (symbols[rand] == '-') {
                rand = (rand + 1) % 36;
            }
            if (symbols[rand] == '-') {
                JOptionPane.showMessageDialog(null, "Cannot find unused element to fill the rotor!", "Fatal error", 0);
                return null;
            }
            rs.append(symbols[rand]);
            symbols[rand] = 45;
            ++i;
        }
        return rs.toString();
    }

    private String genNotch() {
        StringBuffer rs = new StringBuffer();
        int i = 0;
        while (i < 36) {
            int rand = this.rnd.nextInt(2);
            rs.append(String.format("%01d", rand));
            ++i;
        }
        return rs.toString();
    }

    private String genPlate() {
        StringBuffer rs = new StringBuffer();
        char[] symbols = new char[36];
        int i = 0;
        while (i < 36) {
            symbols[i] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".charAt(i);
            ++i;
        }
        i = 0;
        while (i < 36) {
            int rand = this.rnd.nextInt(36);
            while (symbols[rand] == '-') {
                rand = (rand + 1) % 36;
            }
            if (symbols[rand] == '-') {
                JOptionPane.showMessageDialog(null, "Cannot find unused element to fill the BasePlate!", "Fatal error", 0);
                return null;
            }
            rs.append(symbols[rand]);
            symbols[rand] = 45;
            ++i;
        }
        return rs.toString();
    }

    private static enum ButtType {
        CANCEL,
        GEN,
        PWD,
        RND;

    }

    private class ButtonHandler
    implements ActionListener {
        private ButtType button;

        public ButtonHandler(ButtType b) {
            this.button = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean exiting = false;
            switch (this.button) {
                case CANCEL: {
                    KL7Rewire.this.exit(0);
                    break;
                }
                case GEN: {
                    exiting = KL7Rewire.this.generateCustomSettings();
                    KL7Rewire.this.passField.setText("");
                    break;
                }
                case RND: {
                    KL7Rewire.this.passField.setEnabled(false);
                    KL7Rewire.this.passField.setText("");
                    KL7Rewire.this.rnd = new SecureRandom();
                    break;
                }
                case PWD: {
                    KL7Rewire.this.rnd = new RndXtea();
                    KL7Rewire.this.passField.setEnabled(true);
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "Catastrophic error,  exiting...", "Fatal error", 0);
                    KL7Rewire.this.exit(-1);
                }
            }
            if (exiting) {
                KL7Rewire.this.exit(0);
            }
        }
    }

    private class CustDocFilter
    extends DocumentFilter {
        String newText = "";

        private CustDocFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) {
            try {
                this.newText = text.replaceAll("=", " ");
                fb.insertString(offset, this.newText, attr);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
            try {
                this.newText = text.replaceAll("=", " ");
                fb.replace(offset, length, this.newText, attrs);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    private class TxtFilter
    extends FileFilter {
        private TxtFilter() {
        }

        @Override
        public boolean accept(File file) {
            boolean ok = false;
            String filename = file.getName();
            if (file.isDirectory()) {
                return true;
            }
            ok = filename.matches("kl7-custom(\\w|\\p{Blank}|-|_)*\\.txt");
            return ok;
        }

        @Override
        public String getDescription() {
            return "kl7-custom*.txt";
        }
    }
}

