/*
 * Decompiled with CFR 0.152.
 */
package gui;

public class Key {
    String[] rotors = new String[8];
    int[] offsets = new int[8];
    int[] nrings = new int[7];
    int[] noffs = new int[7];
    String bStart;
    String[] checksum = new String[2];
    String[] sysInd;
    boolean newNRings = true;
    String day;
    String mon;
    String year;
    static final String[] rotorNames = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M"};
    static final String[] indices = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36"};
    static final String[] nringNames = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"};
    static final String[] nRingMark = new String[]{"A", "B", "B+", "C", "D", "E", "E+", "F", "G", "G+", "H", "I", "J", "J+", "K", "L", "M", "M+", "N", "O", "O+", "P", "Q", "R", "R+", "S", "T", "T+", "U", "V", "W", "W+", "X", "Y", "Z", "Z+"};
    static final String rNamInd = "ABCDEFGHIJKLM";

    public Key() {
        this.checksum[0] = "";
        this.checksum[1] = "";
        this.bStart = "";
        this.sysInd = new String[2];
        this.sysInd[0] = "";
        this.sysInd[1] = "";
        this.newNRings = true;
    }

    public static void main(String[] args) {
    }

    public boolean useNewNRings() {
        return this.newNRings;
    }

    public void setNewNRings(boolean x) {
        this.newNRings = x;
    }

    public int validateRotors() {
        int[] rotArray = new int[rotorNames.length];
        int i = 0;
        while (i < rotorNames.length) {
            rotArray[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 8) {
            int k = rNamInd.indexOf(this.rotors[i]);
            if (k == -1 || rotArray[k] == -1) {
                return k;
            }
            rotArray[k] = -1;
            ++i;
        }
        return -4;
    }

    public int validateNRings() {
        int[] ringArray = new int[11];
        int i = 0;
        while (i < 11) {
            ringArray[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 7) {
            if (this.nrings[i] < 1 || this.nrings[i] > 11) {
                return -1;
            }
            int k = this.nrings[i] - 1;
            if (ringArray[k] == -1) {
                return k;
            }
            ringArray[k] = -1;
            ++i;
        }
        return -4;
    }

    public final String getRotor(int i) {
        return this.rotors[i];
    }

    public final int getNRing(int i) {
        return this.nrings[i];
    }

    public final int getOffset(int i) {
        return this.offsets[i];
    }

    public final int getNRoffs(int i) {
        return this.noffs[i];
    }

    public final String getCharIndicator() {
        return this.sysInd[0];
    }

    public final String getNumIndicator() {
        return this.sysInd[1];
    }

    void dumpKey() {
        System.out.print("Rotors:              ");
        int i = 0;
        while (i < 8) {
            System.out.print(" " + this.rotors[i] + "  ");
            ++i;
        }
        System.out.println();
        System.out.print("Alpha ring offset:   ");
        i = 0;
        while (i < 8) {
            System.out.print(" " + String.format("%02d", this.offsets[i]) + " ");
            ++i;
        }
        System.out.println();
        System.out.print("Notch rings:         ");
        i = 0;
        while (i < 7) {
            System.out.print(" " + String.format("%2d", this.nrings[i]) + " ");
            ++i;
        }
        System.out.println();
        System.out.print("Notch ring position: ");
        if (this.newNRings) {
            i = 0;
            while (i < 7) {
                System.out.print(" " + String.format("%2s", nRingMark[this.noffs[i] - 1]) + " ");
                ++i;
            }
        } else {
            i = 0;
            while (i < 7) {
                System.out.print(" " + String.format("%02d", this.noffs[i]) + " ");
                ++i;
            }
        }
        System.out.println();
        System.out.println("Msg rotor alignment: " + this.bStart);
        System.out.println("36-45 Ltr Checksum:  " + this.checksum[0] + "/" + this.checksum[1]);
        System.out.println("System Indicator:    " + this.sysInd[0] + " " + this.sysInd[1]);
    }
}

