/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.KL7Sim;
import gui.UppercaseDocumentFilter;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AbstractDocument;

public class Kl7Clip
extends JFrame {
    static final long serialVersionUID = 1525591L;
    private JPanel contentPane;
    private String txt;
    private KL7Sim ksim;
    private final JTextArea textArea;
    private final JScrollPane scrollText;
    private final JFileChooser fc;
    private final TxtFilter tf;
    private Font font = new Font("Courier New", 0, 15);
    private boolean standAlone = false;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Kl7Clip frame = new Kl7Clip();
                    frame.standAlone = true;
                    frame.setVisible(true);
                    frame.textArea.setText("This is a nice test.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Kl7Clip(KL7Sim ksim) {
        this();
        this.ksim = ksim;
        this.txt = ksim.getOutputText();
        this.textArea.setText(this.txt);
    }

    public Kl7Clip() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            System.err.println("Tough luck: " + e.toString());
            e.printStackTrace(System.err);
            System.exit(-2);
        }
        this.setResizable(false);
        this.setVisible(false);
        this.setDefaultCloseOperation(0);
        this.setBounds(10, 30, 530, 450);
        this.setTitle("KL-7 Clipboard");
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        JLabel label = new JLabel("       ");
        label.setBounds(5, 5, 450, 16);
        label.setEnabled(false);
        this.contentPane.add(label);
        this.fc = new JFileChooser();
        this.tf = new TxtFilter();
        this.fc.setFileFilter(this.tf);
        this.textArea = new JTextArea();
        this.textArea.setBorder(new BevelBorder(1, null, null, null, null));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEnabled(true);
        this.textArea.setEditable(true);
        this.textArea.setFont(this.font);
        this.scrollText = new JScrollPane(this.textArea);
        this.scrollText.setEnabled(true);
        this.scrollText.setBounds(5, 21, 519, 360);
        this.scrollText.setHorizontalScrollBarPolicy(31);
        this.scrollText.setVerticalScrollBarPolicy(20);
        this.contentPane.add((Component)this.scrollText, "Center");
        UppercaseDocumentFilter filter = new UppercaseDocumentFilter();
        ((AbstractDocument)this.textArea.getDocument()).setDocumentFilter(filter);
        JButton btnClipboard = new JButton("To Clipboard");
        btnClipboard.setBounds(129, 393, 118, 29);
        btnClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StringSelection ss = new StringSelection(Kl7Clip.this.textArea.getText());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
                if (!Kl7Clip.this.standAlone) {
                    Kl7Clip.this.ksim.outDropFocus();
                }
            }
        });
        this.contentPane.add(btnClipboard);
        JButton btnClose = new JButton("Close");
        btnClose.setBounds(429, 393, 95, 29);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Kl7Clip.this.standAlone) {
                    System.exit(0);
                } else {
                    Kl7Clip.this.ksim.outDropFocus();
                    Kl7Clip.this.setVisible(false);
                }
            }
        });
        this.contentPane.add(btnClose);
        JButton btnSaveToFile = new JButton("Save to File");
        btnSaveToFile.setBounds(303, 393, 102, 29);
        btnSaveToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintWriter prout = null;
                int result = Kl7Clip.this.fc.showSaveDialog(null);
                switch (result) {
                    case 0: {
                        File of = Kl7Clip.this.fc.getSelectedFile();
                        try {
                            try {
                                prout = new PrintWriter(of);
                                String s = Kl7Clip.this.textArea.getText();
                                if (s.length() <= 60) {
                                    prout.println(s);
                                } else {
                                    int i = 0;
                                    int k = 60;
                                    while (k <= s.length()) {
                                        if ((k = s.lastIndexOf(32, k)) <= 0) continue;
                                        prout.println(s.substring(i, k + 1));
                                        i = k + 1;
                                        k += 60;
                                    }
                                    if (i < s.length()) {
                                        prout.println(s.substring(i));
                                    }
                                }
                            }
                            catch (IOException exep) {
                                JOptionPane.showMessageDialog(null, "Could not save to file \"" + of.getName() + "\" " + exep.getMessage(), "Error writing file", 0);
                                exep.printStackTrace();
                                if (prout == null) break;
                                prout.close();
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            if (prout != null) {
                                prout.close();
                            }
                            throw throwable;
                        }
                        if (prout == null) break;
                        prout.close();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case -1: {
                        JOptionPane.showMessageDialog(null, "Problem opening or saving file", "Could not save to this file", 0);
                    }
                }
                if (!Kl7Clip.this.standAlone) {
                    Kl7Clip.this.ksim.outDropFocus();
                }
            }
        });
        this.contentPane.add(btnSaveToFile);
        JButton btnClear = new JButton("Clear");
        btnClear.setAlignmentX(0.5f);
        btnClear.setToolTipText("Clear the text from (erase) the output tape.");
        btnClear.setBounds(5, 393, 68, 29);
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Kl7Clip.this.textArea.setText("");
                if (!Kl7Clip.this.standAlone) {
                    Kl7Clip.this.ksim.clearOutputTape();
                }
            }
        });
        this.contentPane.add(btnClear);
    }

    public void setTextArea(String s) {
        this.textArea.setText(s);
    }

    private class TxtFilter
    extends FileFilter {
        private TxtFilter() {
        }

        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            if (file.isDirectory()) {
                return true;
            }
            return filename.endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return "*.txt";
        }
    }
}

