/*
 * Decompiled with CFR 0.152.
 */
package kl7;

import gui.Key;
import java.io.Serializable;
import kl7.BoxMode;
import kl7.Cage;
import kl7.Register;

public class Box
implements Serializable {
    private static final long serialVersionUID = -8326918301359239896L;
    final char FIG = (char)123;
    final char LET = (char)125;
    final String digletters = "QWERTYUIOP";
    final String digits = "1234567890";
    Cage cage = new Cage();
    BoxMode currMode = BoxMode.O;
    BoxMode mode;
    Register reg = Register.LET;
    int counter = 0;
    boolean newNRings = false;

    public void setBoxMode(BoxMode param) {
        if (this.currMode == BoxMode.P && param == BoxMode.E || this.currMode == BoxMode.E && param == BoxMode.P || this.currMode == BoxMode.P && param == BoxMode.D || this.currMode == BoxMode.D && param == BoxMode.P || this.currMode == BoxMode.O && param == BoxMode.E || this.currMode == BoxMode.D && param == BoxMode.O || this.currMode == BoxMode.E && param == BoxMode.O) {
            ++this.counter;
            this.cage.step();
        }
        this.currMode = param;
    }

    public BoxMode getBoxMode() {
        return this.currMode;
    }

    public void setReg(Register newReg) {
        this.reg = newReg;
    }

    public Register getReg() {
        return this.reg;
    }

    public void increaseCounter() {
        ++this.counter;
    }

    public void incCounterBy(int i) {
        this.counter += i;
    }

    public void resetCounter() {
        this.counter = 0;
    }

    public int getCounter() {
        return this.counter;
    }

    public boolean getNewNRings() {
        return this.newNRings;
    }

    public void setNewNRings(boolean x) {
        this.newNRings = x;
    }

    public void setRotor(String nam, int pos) {
        this.cage.setRotor(nam, pos);
    }

    public String getRotor(int pos) {
        return this.cage.getRotor(pos);
    }

    public boolean setCustomRotor(String r, String custom) {
        return this.cage.setCustomRotor(r, custom);
    }

    public boolean setCustomNRing(int ring, String custom) {
        if (ring < 1 || ring > 11) {
            System.err.println("Box.setCustomNRing(" + ring + ", " + custom + "): illegal ring# (must be 1..11)");
            return false;
        }
        if (custom.length() != 36) {
            System.err.println("Box.setCustomNRing(" + ring + ", " + custom + "):");
            System.err.println("\tillegal length: " + custom.length() + ", must be 36");
            return false;
        }
        int[] cus = new int[36];
        if (!custom.matches("[01]{36}")) {
            System.err.println("Box.setCustomNRing(" + ring + ", " + custom + "): illegal string - must contain only 1 and 0");
            return false;
        }
        int i = 0;
        while (i < 36) {
            cus[i] = custom.charAt(i) == '0' ? 0 : 1;
            ++i;
        }
        return this.cage.setCustomNRing(ring, cus);
    }

    public boolean setCustomBasePlate(String custom) {
        if (!custom.matches("\\w{36}")) {
            System.err.println("Box.setCustomPlate(" + custom + "): " + " illegal string!");
            return false;
        }
        return this.cage.setCustomBasePlate(custom);
    }

    public void setRotorStart(int pos, byte off) {
        if (off < 0 || off > 35) {
            System.err.println("Box::setRotorStart(" + pos + "," + off + "): illegal slot# or pos#");
            return;
        }
        this.cage.setRotorStart(pos, off);
    }

    public byte getRotorStart(int pos) {
        return this.cage.getRotorStart(pos);
    }

    public char getRotorWin(int pos) {
        return this.cage.getRotorWin(pos);
    }

    public int getRotorInt(int pos) {
        return this.cage.getRotorInt(pos);
    }

    public char[] getRotorFullWin(int pos) {
        return this.cage.getRotorFullWin(pos);
    }

    public void setRotorWin(int pos, char x) {
        if (pos < 0 || pos > 7 || x < 'A' || x > 'Z' || pos == 3) {
            return;
        }
        this.cage.setRotorWin(pos, x);
    }

    public void setRotorInt(int pos, int x) {
        if (pos < 0 || pos > 7 || pos == 3) {
            return;
        }
        this.cage.setRotorWin(pos, x);
    }

    public void setNRing(int pos, int ring) {
        if (pos < 0 || pos > 6) {
            return;
        }
        this.cage.setNRing(pos, ring);
    }

    public int getNRing(int pos) {
        if (pos < 0 || pos > 6) {
            return -1;
        }
        return this.cage.getNRing(pos);
    }

    public void setNRingPos(int pos, int off) {
        if (pos < 0 || pos > 6 || off < 0 || off > 35) {
            return;
        }
        this.cage.setNRingPos(pos, off);
    }

    public int getNRingAlphPos(int pos) {
        if (pos < 0 || pos > 6) {
            return -1;
        }
        return this.cage.getNRingAlphPos(pos);
    }

    public void setNRingAlphPos(int pos, int off) {
        if (pos < 0 || pos > 6 || off < 0 || off > 35) {
            System.err.println("Box::setNRingAlphPos(" + pos + "," + off + "): illegal slot# or offset");
            return;
        }
        this.cage.setNRingAlphPos(pos, off);
    }

    public int getNRingPos(int pos) {
        if (pos < 0 || pos > 6) {
            return -1;
        }
        return this.cage.getNRingPos(pos);
    }

    public void setBox(Key key) {
        if (key.validateRotors() != -4 || key.validateNRings() != -4) {
            return;
        }
        this.newNRings = key.useNewNRings();
        int i = 0;
        while (i < 8) {
            this.setRotor(key.getRotor(i), i);
            this.setRotorStart(i, (byte)(key.getOffset(i) - 1 & 0xFF));
            this.setRotorWin(i, 'A');
            if (i != 7) {
                this.setNRing(i, key.getNRing(i) - 1);
                this.setNRingPos(i, key.getNRoffs(i) - 1);
                if (this.newNRings) {
                    int k = i < 3 ? i : i + 1;
                    this.setNRingAlphPos(i, this.getRotorStart(k));
                } else {
                    this.setNRingAlphPos(i, 0);
                }
            }
            ++i;
        }
    }

    public void reconfigureCage() {
        this.cage.reconfigureCage();
    }

    public String prepareEncString(String in) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char ch = in.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == ' ' || ch == '{' || ch == '}') {
                out.append(this.prepareEncChar(ch));
            }
            ++i;
        }
        return out.toString();
    }

    public String prepareEncChar(char ch) {
        String out = "";
        switch (ch) {
            case '{': {
                this.reg = Register.FIG;
                out = String.valueOf(out) + 'J';
                break;
            }
            case '}': {
                this.reg = Register.LET;
                out = String.valueOf(out) + 'V';
                break;
            }
            case 'Z': {
                if (this.reg == Register.FIG) {
                    this.reg = Register.LET;
                    out = String.valueOf(out) + 'V';
                }
                out = String.valueOf(out) + 'X';
                break;
            }
            case ' ': {
                out = String.valueOf(out) + 'Z';
                break;
            }
            case 'J': {
                if (this.reg == Register.FIG) {
                    this.reg = Register.LET;
                    out = String.valueOf(out) + 'V';
                }
                out = String.valueOf(out) + 'Y';
                break;
            }
            case '1': {
                if (this.reg == Register.LET) {
                    this.reg = Register.FIG;
                    out = String.valueOf(out) + 'J';
                }
                out = String.valueOf(out) + 'Q';
                break;
            }
            case '2': {
                if (this.reg == Register.LET) {
                    this.reg = Register.FIG;
                    out = String.valueOf(out) + 'J';
                }
                out = String.valueOf(out) + 'W';
                break;
            }
            case '3': {
                if (this.reg == Register.LET) {
                    this.reg = Register.FIG;
                    out = String.valueOf(out) + 'J';
                }
                out = String.valueOf(out) + 'E';
                break;
            }
            case '4': {
                if (this.reg == Register.LET) {
                    this.reg = Register.FIG;
                    out = String.valueOf(out) + 'J';
                }
                out = String.valueOf(out) + 'R';
                break;
            }
            case '5': {
                if (this.reg == Register.LET) {
                    this.reg = Register.FIG;
                    out = String.valueOf(out) + 'J';
                }
                out = String.valueOf(out) + 'T';
                break;
            }
            case '6': {
                if (this.reg == Register.LET) {
                    this.reg = Register.FIG;
                    out = String.valueOf(out) + 'J';
                }
                out = String.valueOf(out) + 'Y';
                break;
            }
            case '7': {
                if (this.reg == Register.LET) {
                    this.reg = Register.FIG;
                    out = String.valueOf(out) + 'J';
                }
                out = String.valueOf(out) + 'U';
                break;
            }
            case '8': {
                if (this.reg == Register.LET) {
                    this.reg = Register.FIG;
                    out = String.valueOf(out) + 'J';
                }
                out = String.valueOf(out) + 'I';
                break;
            }
            case '9': {
                if (this.reg == Register.LET) {
                    this.reg = Register.FIG;
                    out = String.valueOf(out) + 'J';
                }
                out = String.valueOf(out) + 'O';
                break;
            }
            case '0': {
                if (this.reg == Register.LET) {
                    this.reg = Register.FIG;
                    out = String.valueOf(out) + 'J';
                }
                out = String.valueOf(out) + 'P';
                break;
            }
            default: {
                if (this.reg == Register.FIG) {
                    this.reg = Register.LET;
                    out = String.valueOf(out) + 'V';
                }
                out = String.valueOf(out) + ch;
            }
        }
        return out;
    }

    public String policeDecString(String in) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            out.append(this.policeDecChar(in.charAt(i)));
            ++i;
        }
        return out.toString();
    }

    public String policeDecChar(char ch) {
        String out = new String();
        switch (ch) {
            case ' ': {
                break;
            }
            case 'Z': {
                out = String.valueOf(out) + ' ';
                break;
            }
            case 'J': {
                this.reg = Register.FIG;
                break;
            }
            case 'Q': {
                if (this.reg == Register.FIG) {
                    out = String.valueOf(out) + '1';
                    break;
                }
                out = String.valueOf(out) + 'Q';
                break;
            }
            case 'W': {
                if (this.reg == Register.FIG) {
                    out = String.valueOf(out) + '2';
                    break;
                }
                out = String.valueOf(out) + 'W';
                break;
            }
            case 'E': {
                if (this.reg == Register.FIG) {
                    out = String.valueOf(out) + '3';
                    break;
                }
                out = String.valueOf(out) + 'E';
                break;
            }
            case 'R': {
                if (this.reg == Register.FIG) {
                    out = String.valueOf(out) + '4';
                    break;
                }
                out = String.valueOf(out) + 'R';
                break;
            }
            case 'T': {
                if (this.reg == Register.FIG) {
                    out = String.valueOf(out) + '5';
                    break;
                }
                out = String.valueOf(out) + 'T';
                break;
            }
            case 'Y': {
                if (this.reg == Register.FIG) {
                    out = String.valueOf(out) + '6';
                    break;
                }
                out = String.valueOf(out) + 'Y';
                break;
            }
            case 'U': {
                if (this.reg == Register.FIG) {
                    out = String.valueOf(out) + '7';
                    break;
                }
                out = String.valueOf(out) + 'U';
                break;
            }
            case 'I': {
                if (this.reg == Register.FIG) {
                    out = String.valueOf(out) + '8';
                    break;
                }
                out = String.valueOf(out) + 'I';
                break;
            }
            case 'O': {
                if (this.reg == Register.FIG) {
                    out = String.valueOf(out) + '9';
                    break;
                }
                out = String.valueOf(out) + 'O';
                break;
            }
            case 'P': {
                if (this.reg == Register.FIG) {
                    out = String.valueOf(out) + '0';
                    break;
                }
                out = String.valueOf(out) + 'P';
                break;
            }
            case 'V': {
                if (this.reg == Register.FIG) {
                    this.reg = Register.LET;
                    out = String.valueOf(out) + ' ';
                    break;
                }
                out = String.valueOf(out) + 'V';
                break;
            }
            default: {
                out = String.valueOf(out) + ch;
            }
        }
        return out;
    }

    public String encryptString(String input) {
        int j = 0;
        if (this.currMode != BoxMode.E) {
            System.out.println("Box encryptString: box in wrong mode " + (Object)((Object)this.currMode));
        }
        String in = this.prepareEncString(input);
        StringBuffer out = new StringBuffer();
        boolean doAppend = false;
        int i = 0;
        while (i < in.length()) {
            char s = this.cage.encode(in.charAt(i));
            if (doAppend) {
                out.append(" ");
                doAppend = false;
            }
            out.append(s);
            if (++j == 5) {
                doAppend = true;
                j = 0;
            }
            ++i;
        }
        this.counter += in.length();
        return out.toString();
    }

    public String decryptString(String input) {
        if (this.currMode != BoxMode.D) {
            System.out.println("Box decryptString: box in wrong mode " + (Object)((Object)this.currMode));
        }
        StringBuffer inp = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (Character.isLetter(ch)) {
                inp.append(ch);
            }
            ++i;
        }
        this.counter += inp.length();
        String in2 = inp.toString();
        String in = this.cage.decodeString(in2);
        String out = this.policeDecString(in);
        return out;
    }

    public char encryptChar(char ch) {
        char out = this.cage.encode(ch);
        ++this.counter;
        return out;
    }

    public char decryptChar(char ch) {
        ++this.counter;
        return this.cage.decode(ch);
    }

    public String getMsgKey() {
        String s = Character.toString(this.getRotorWin(0));
        s = String.valueOf(s) + Character.toString(this.getRotorWin(1));
        s = String.valueOf(s) + Character.toString(this.getRotorWin(2));
        s = String.valueOf(s) + Character.toString(this.getRotorWin(4));
        s = String.valueOf(s) + Character.toString(this.getRotorWin(5));
        s = String.valueOf(s) + Character.toString(this.getRotorWin(6));
        s = String.valueOf(s) + Character.toString(this.getRotorWin(7));
        return s;
    }

    public int[] getIntKey() {
        int[] key = new int[]{this.getRotorInt(0), this.getRotorInt(1), this.getRotorInt(2), this.getRotorInt(4), this.getRotorInt(5), this.getRotorInt(6), this.getRotorInt(7)};
        return key;
    }

    public void setMsgKey(String key) {
        if (key.length() != 7) {
            System.err.println("setMsgKey: wrong message key size (must be 7) " + key);
            return;
        }
        this.cage.setRotorWin(0, key.charAt(0));
        this.cage.setRotorWin(1, key.charAt(1));
        this.cage.setRotorWin(2, key.charAt(2));
        this.cage.setRotorWin(4, key.charAt(3));
        this.cage.setRotorWin(5, key.charAt(4));
        this.cage.setRotorWin(6, key.charAt(5));
        this.cage.setRotorWin(7, key.charAt(6));
    }

    public void setMsgKey(int[] key) {
        this.cage.setRotorWin(0, key[0]);
        this.cage.setRotorWin(1, key[1]);
        this.cage.setRotorWin(2, key[2]);
        this.cage.setRotorWin(4, key[3]);
        this.cage.setRotorWin(5, key[4]);
        this.cage.setRotorWin(6, key[5]);
        this.cage.setRotorWin(7, key[6]);
    }

    public void dumpCage() {
        String fmt;
        int k;
        System.out.println("Rotor setting is:");
        int i = 0;
        while (i < 8) {
            System.out.print("\t" + i + "-" + this.cage.getRotor(i) + "\t");
            k = this.cage.getRotorStart(i);
            fmt = String.format("%02d", k);
            System.out.print(" Letter Ring offset: " + fmt + " ");
            if (i != 3) {
                System.out.print("\twin: " + this.cage.getRotorWin(i));
            }
            System.out.println();
            ++i;
        }
        System.out.println("Notch Ring setting is:");
        i = 0;
        while (i < 7) {
            k = this.cage.getNRingPos(i);
            fmt = String.format("%02d - %02d", k, this.cage.getNRingAlphPos(i));
            System.out.println("\t" + i + "-" + this.cage.getNRing(i) + "\t" + "NRing offset: " + fmt);
            ++i;
        }
        System.out.println();
        this.cage.plate.dumpPlate();
    }

    public void dumpBox() {
        System.out.print("Box mode: " + (Object)((Object)this.getBoxMode()) + " " + (Object)((Object)this.getReg()));
        System.out.println("\tprocessed " + this.counter + " characters");
        this.dumpCage();
    }
}

