/*
 * Decompiled with CFR 0.152.
 */
package kl7;

import java.io.Serializable;
import kl7.BasePlate;
import kl7.NotchRing;
import kl7.Rotor;

class Cage
implements Serializable {
    private static final long serialVersionUID = -7784569037741201839L;
    Rotor[] rotRepo;
    Rotor[] rotors;
    NotchRing[] nRingRepo;
    NotchRing[] nRings;
    BasePlate plate = new BasePlate();
    static final String rNamInd = "ABCDEFGHIJKLM";

    public Cage() {
        this.rotRepo = new Rotor[rNamInd.length()];
        int i = 0;
        while (i < rNamInd.length()) {
            this.rotRepo[i] = new Rotor(rNamInd.substring(i, i + 1));
            ++i;
        }
        this.rotors = new Rotor[8];
        this.nRingRepo = new NotchRing[11];
        i = 0;
        while (i < 11) {
            this.nRingRepo[i] = new NotchRing(i + 1);
            ++i;
        }
        this.nRings = new NotchRing[7];
        this.setCageUSSBeagle();
    }

    public void setCageUSSBeagle() {
        this.rotors[0] = this.rotRepo[4];
        this.rotors[0].setRotorPos((byte)3);
        this.rotors[1] = this.rotRepo[7];
        this.rotors[1].setRotorPos((byte)27);
        this.rotors[2] = this.rotRepo[5];
        this.rotors[2].setRotorPos((byte)3);
        this.rotors[3] = this.rotRepo[11];
        this.rotors[3].setRotorPos((byte)15);
        this.rotors[4] = this.rotRepo[8];
        this.rotors[4].setRotorPos((byte)8);
        this.rotors[5] = this.rotRepo[0];
        this.rotors[5].setRotorPos((byte)31);
        this.rotors[6] = this.rotRepo[6];
        this.rotors[6].setRotorPos((byte)7);
        this.rotors[7] = this.rotRepo[1];
        this.rotors[7].setRotorPos((byte)10);
        this.nRings[0] = this.nRingRepo[4];
        this.nRings[0].setRingPos((byte)3);
        this.nRings[1] = this.nRingRepo[9];
        this.nRings[1].setRingPos((byte)33);
        this.nRings[2] = this.nRingRepo[5];
        this.nRings[2].setRingPos((byte)24);
        this.nRings[3] = this.nRingRepo[6];
        this.nRings[3].setRingPos((byte)8);
        this.nRings[4] = this.nRingRepo[0];
        this.nRings[4].setRingPos((byte)2);
        this.nRings[5] = this.nRingRepo[7];
        this.nRings[5].setRingPos((byte)26);
        this.nRings[6] = this.nRingRepo[2];
        this.nRings[6].setRingPos((byte)13);
        this.rotors[0].setWinAPos('X');
        this.rotors[1].setWinAPos('E');
        this.rotors[2].setWinAPos('G');
        this.rotors[4].setWinAPos('B');
        this.rotors[5].setWinAPos('V');
        this.rotors[6].setWinAPos('E');
        this.rotors[7].setWinAPos('Q');
    }

    public void setDefaultKey() {
        this.rotors[0].setWinAPos('A');
        this.rotors[1].setWinAPos('A');
        this.rotors[2].setWinAPos('A');
        this.rotors[4].setWinAPos('A');
        this.rotors[5].setWinAPos('A');
        this.rotors[6].setWinAPos('A');
        this.rotors[7].setWinAPos('A');
    }

    public void step() {
        int[] stepSwitch = new int[8];
        int i = 0;
        while (i < 8) {
            stepSwitch[i] = 0;
            ++i;
        }
        if (this.nRings[6].bump((byte)this.rotors[7].getCurPos()) == 0 && (this.nRings[1].bump((byte)this.rotors[1].getCurPos()) == 0 || this.nRings[2].bump((byte)this.rotors[2].getCurPos()) == 0)) {
            stepSwitch[0] = 1;
        }
        if (this.nRings[4].bump((byte)this.rotors[5].getCurPos()) == 0 || this.nRings[5].bump((byte)this.rotors[6].getCurPos()) == 0) {
            stepSwitch[1] = 1;
        }
        if (this.nRings[1].bump((byte)this.rotors[1].getCurPos()) == 1 || this.nRings[5].bump((byte)this.rotors[6].getCurPos()) == 1) {
            stepSwitch[2] = 1;
        }
        stepSwitch[3] = 0;
        if (this.nRings[1].bump((byte)this.rotors[1].getCurPos()) == 0 || this.nRings[2].bump((byte)this.rotors[2].getCurPos()) == 0) {
            stepSwitch[4] = 1;
        }
        if (this.nRings[0].bump((byte)this.rotors[0].getCurPos()) == 0 || this.nRings[2].bump((byte)this.rotors[2].getCurPos()) == 1) {
            stepSwitch[5] = 1;
        }
        if (this.nRings[0].bump((byte)this.rotors[0].getCurPos()) == 1 || this.nRings[4].bump((byte)this.rotors[5].getCurPos()) == 1) {
            stepSwitch[6] = 1;
        }
        if (this.nRings[3].bump((byte)this.rotors[4].getCurPos()) == 0 && (this.nRings[1].bump((byte)this.rotors[1].getCurPos()) == 0 || this.nRings[2].bump((byte)this.rotors[2].getCurPos()) == 0)) {
            stepSwitch[7] = 1;
        }
        i = 0;
        while (i < 8) {
            if (stepSwitch[i] == 1) {
                this.rotors[i].stepRotor();
            }
            ++i;
        }
    }

    public char encode(char sym) {
        byte s = (byte)sym;
        int k = 0;
        do {
            s = this.plate.enterCage(s);
            int i = 0;
            while (i < 8) {
                s = this.rotors[i].encode(s);
                ++i;
            }
            s = this.plate.leaveCage(s);
            ++k;
        } while (s < 36);
        this.step();
        return (char)s;
    }

    public char decode(char sym) {
        byte s = (byte)sym;
        int k = 0;
        do {
            s = this.plate.enterCage(s);
            int i = 7;
            while (i >= 0) {
                s = this.rotors[i].decode(s);
                --i;
            }
            s = this.plate.leaveCage(s);
            ++k;
        } while (s < 36);
        this.step();
        return (char)s;
    }

    public void setRotor(String r, int pos) {
        int i = rNamInd.indexOf(r);
        if (i == -1 || pos < 0 || pos > 7) {
            System.err.println("For rotor \"" + r + "\" slot #" + pos + " is wrong! must be 0<=pos < 8");
        }
        this.rotors[pos] = this.rotRepo[i];
        this.rotors[pos].setRotorPos((byte)0);
    }

    public boolean setCustomRotor(String r, String custom) {
        if (r == null) {
            return false;
        }
        int i = rNamInd.indexOf(r);
        if (i == -1) {
            System.err.println("Rotor  name \"" + r + "\" is wrong! " + " must be [A-M]");
            return false;
        }
        Rotor rr = new Rotor(r, custom);
        if (rr != null && rr.validateThisRotor()) {
            this.rotRepo[i] = new Rotor(r, custom);
            return true;
        }
        return false;
    }

    public String getRotor(int pos) {
        if (pos < 0 || pos > 7) {
            return "ERROR! Wrong pos!";
        }
        return this.rotors[pos].getName();
    }

    public void setRotorStart(int pos, byte x) {
        if (pos < 0 || pos > 7) {
            System.exit(-10);
        }
        if (x < 0 || x > 35) {
            return;
        }
        this.rotors[pos].setRotorPos(x);
    }

    public byte getRotorStart(int pos) {
        if (pos < 0 || pos > 7) {
            System.exit(-10);
        }
        return this.rotors[pos].getRotorPos();
    }

    public void setRotorWin(int pos, int off) {
        if (pos < 0 || pos > 7) {
            System.exit(-10);
        }
        this.rotors[pos].setWinPos((byte)(off & 0xFF));
    }

    public void setRotorWin(int pos, char x) {
        if (pos < 0 || pos > 7) {
            System.exit(-10);
        }
        this.rotors[pos].setWinAPos(x);
    }

    public char getRotorWin(int pos) {
        if (pos < 0 || pos > 7) {
            System.exit(-10);
        }
        if (pos == 3) {
            return ' ';
        }
        return this.rotors[pos].getWinPos();
    }

    public int getRotorInt(int pos) {
        if (pos == 3) {
            return 0;
        }
        return this.rotors[pos].getCurPos();
    }

    public char[] getRotorFullWin(int pos) {
        char[] bull = new char[]{' ', ' ', ' '};
        if ((pos %= 8) == 3) {
            return bull;
        }
        return this.rotors[pos].getFullWinPos();
    }

    public void setNRing(int pos, int ring) {
        this.nRings[pos] = this.nRingRepo[ring];
        this.nRings[pos].setRingPos((byte)0);
    }

    public int getNRing(int pos) {
        if (pos < 0 || pos > 6) {
            return -1;
        }
        int i = Integer.valueOf(this.nRings[pos].getName());
        return i;
    }

    public void setNRingPos(int pos, int offset) {
        if (offset > 35 || offset < 0) {
            return;
        }
        if (pos > 6) {
            return;
        }
        this.nRings[pos].setRingPos((byte)(offset & 0xFF));
    }

    public int getNRingPos(int pos) {
        if (pos < 0 || pos > 6) {
            System.err.println("cage.getNRingPos(" + pos + "): illegal pos#");
            System.exit(-7);
        }
        return this.nRings[pos].getRingPos();
    }

    public void setNRingAlphPos(int pos, int offset) {
        if (offset > 35 || offset < 0) {
            return;
        }
        if (pos < 0 || pos > 6) {
            return;
        }
        this.nRings[pos].setAlphPos((byte)(offset & 0xFF));
    }

    public int getNRingAlphPos(int pos) {
        if (pos < 0 || pos > 6) {
            System.err.println("cage.getNRingPos(" + pos + "): illegal pos#");
            System.exit(-7);
        }
        return this.nRings[pos].getAlphPos();
    }

    public boolean setCustomNRing(int ring, int[] custom) {
        if (ring < 1 || ring > 11) {
            System.err.println("Notched ring #" + ring + ": ring # is wrong! must be 1<=NRing <= 11 ");
            return false;
        }
        if (custom == null || custom.length != 36) {
            System.err.println("setCustomNRing(" + ring + "): " + "wrong ring contents!");
            return false;
        }
        NotchRing nn = new NotchRing(ring, custom);
        if (nn.validateNRing(custom)) {
            this.nRingRepo[ring - 1] = nn;
            return true;
        }
        System.err.println("setCustomNRing(" + ring + "): " + "ring failed validation!");
        return false;
    }

    boolean setCustomBasePlate(String custom) {
        if (custom.length() != 36) {
            this.plate = new BasePlate();
            System.err.println("setCustomBasePlate(" + custom + "): " + " given " + custom.length() + " chars instead of 36");
            return false;
        }
        this.plate = new BasePlate(custom);
        return this.plate.validateThisPlate();
    }

    void reconfigureCage() {
        String rNam = null;
        byte rPos = 0;
        byte rWin = 0;
        int nRing = 0;
        byte nRPos = 0;
        byte aPos = 0;
        int i = 0;
        while (i < 8) {
            rNam = this.rotors[i].getName();
            rPos = this.rotors[i].getRotorPos();
            if (i != 3) {
                rWin = (byte)this.rotors[i].getCurPos();
            }
            this.setRotor(rNam, i);
            this.setRotorStart(i, rPos);
            if (i != 3) {
                this.rotors[i].setWinPos(rWin);
            }
            if (i != 7) {
                nRing = this.nRings[i].getRing();
                nRPos = this.nRings[i].getRingPos();
                aPos = this.nRings[i].getAlphPos();
                this.setNRing(i, nRing - 1);
                this.setNRingPos(i, nRPos);
                this.nRings[i].setAlphPos(aPos);
            }
            ++i;
        }
    }

    public String encodeString(String in) {
        int len = in.length();
        char[] s = new char[len];
        int i = 0;
        while (i < len) {
            s[i] = this.encode(in.charAt(i));
            ++i;
        }
        String out = new String(s);
        return out;
    }

    public String decodeString(String in) {
        int len = in.length();
        char[] s = new char[len];
        int i = 0;
        while (i < len) {
            s[i] = this.decode(in.charAt(i));
            ++i;
        }
        String out = new String(s);
        return out;
    }

    public void dumpRotors() {
        int i = 0;
        while (i < 8) {
            this.rotors[i].dumpRotor();
            ++i;
        }
    }

    public void testRotors() {
        int i = 0;
        while (i < 8) {
            this.rotors[i].testRotor();
            ++i;
        }
    }

    public void dumpNotchRings() {
        int i = 0;
        while (i < 7) {
            this.nRings[i].dumpRing();
            ++i;
        }
    }
}

