/*
 * Decompiled with CFR 0.152.
 */
package kl7;

import java.io.Serializable;

class Rotor
implements Serializable {
    private static final long serialVersionUID = 5772442526720464073L;
    private byte[] wiringMaze;
    private byte[] inversMaze;
    private String name;
    private byte winPos;
    private byte startPos;
    private final String rotInd = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    public static final byte[] ringLetterMark = new byte[]{65, 66, 32, 67, 68, 69, 32, 70, 71, 32, 72, 73, 74, 32, 75, 76, 77, 32, 78, 79, 32, 80, 81, 82, 32, 83, 84, 32, 85, 86, 87, 32, 88, 89, 90, 32};
    byte[] ringRevMark;
    static final byte[] wirA = new byte[]{29, 27, 14, 8, 35, 4, 28, 11, 5, 13, 20, 3, 25, 33, 18, 15, 7, 12, 34, 16, 17, 1, 9, 30, 24, 23, 2, 32, 10, 19, 6, 26, 36, 22, 31, 21};
    static final byte[] wirB = new byte[]{23, 19, 26, 16, 2, 13, 14, 35, 21, 4, 17, 31, 25, 3, 18, 27, 12, 34, 36, 10, 30, 6, 7, 15, 28, 1, 11, 33, 29, 20, 32, 24, 5, 22, 8, 9};
    static final byte[] wirC = new byte[]{19, 26, 28, 36, 6, 25, 31, 18, 27, 10, 5, 1, 32, 9, 11, 33, 23, 17, 29, 12, 13, 2, 16, 15, 35, 8, 24, 22, 30, 3, 34, 14, 7, 20, 21, 4};
    static final byte[] wirD = new byte[]{15, 26, 36, 13, 1, 31, 25, 33, 3, 32, 21, 23, 17, 29, 7, 22, 20, 24, 12, 10, 14, 30, 19, 28, 4, 35, 5, 8, 6, 9, 16, 27, 2, 11, 34, 18};
    static final byte[] wirE = new byte[]{13, 4, 2, 16, 17, 30, 21, 5, 33, 7, 29, 8, 9, 36, 35, 23, 34, 25, 20, 22, 28, 15, 1, 19, 24, 27, 10, 11, 6, 12, 32, 26, 14, 3, 18, 31};
    static final byte[] wirF = new byte[]{26, 34, 27, 14, 2, 1, 31, 36, 11, 9, 35, 18, 15, 12, 4, 7, 29, 8, 23, 19, 3, 30, 20, 17, 28, 21, 22, 5, 25, 33, 16, 13, 24, 6, 10, 32};
    static final byte[] wirG = new byte[]{20, 19, 9, 32, 36, 2, 6, 33, 12, 28, 4, 10, 3, 24, 29, 16, 22, 18, 30, 17, 7, 34, 15, 23, 31, 25, 27, 1, 21, 26, 8, 5, 13, 35, 11, 14};
    static final byte[] wirH = new byte[]{28, 19, 23, 5, 17, 36, 27, 14, 16, 20, 21, 7, 12, 22, 11, 35, 13, 15, 1, 32, 8, 18, 33, 4, 9, 29, 26, 24, 25, 34, 10, 6, 3, 30, 2, 31};
    static final byte[] wirI = new byte[]{25, 6, 35, 12, 21, 22, 19, 32, 20, 23, 30, 18, 1, 16, 31, 11, 24, 13, 33, 7, 36, 9, 34, 2, 10, 8, 26, 29, 15, 17, 4, 28, 14, 3, 27, 5};
    static final byte[] wirJ = new byte[]{8, 31, 1, 28, 20, 6, 32, 5, 33, 21, 30, 12, 4, 14, 15, 34, 7, 35, 16, 18, 29, 22, 25, 26, 36, 11, 23, 19, 3, 2, 13, 27, 24, 10, 17, 9};
    static final byte[] wirK = new byte[]{15, 13, 36, 23, 6, 21, 32, 18, 31, 20, 1, 24, 10, 35, 19, 28, 7, 8, 26, 12, 29, 22, 25, 30, 5, 9, 2, 27, 16, 4, 17, 3, 34, 14, 11, 33};
    static final byte[] wirL = new byte[]{8, 18, 15, 33, 7, 26, 20, 16, 34, 23, 36, 27, 12, 24, 19, 13, 2, 3, 14, 29, 1, 6, 32, 10, 25, 30, 9, 5, 28, 17, 22, 31, 4, 11, 21, 35};
    static final byte[] wirM = new byte[]{36, 6, 29, 28, 24, 26, 21, 22, 20, 35, 15, 19, 23, 30, 1, 8, 12, 7, 13, 27, 31, 32, 9, 33, 10, 16, 14, 18, 34, 2, 3, 17, 25, 11, 4, 5};
    static final String[] rName = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M"};
    static final String rNamInd = "ABCDEFGHIJKLM";

    byte convIDtoNum(String id) {
        int i = id.charAt(0) - 65;
        return (byte)((byte)i & 0xFF);
    }

    void setWiringMaze(int index) {
        boolean one = true;
        if (index < 0 || index > 12) {
            System.err.println("Rotor() ERROR: wrong name/index " + index + " (must be between 0 and 11");
            System.exit(-3);
        }
        this.ringRevMark = new byte[256];
        int i = 0;
        while (i < 256) {
            this.ringRevMark[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 36) {
            if (ringLetterMark[i] != 32) {
                this.ringRevMark[Rotor.ringLetterMark[i]] = (byte)i;
            }
            ++i;
        }
        this.wiringMaze = new byte[37];
        this.inversMaze = new byte[256];
        switch (index) {
            case 0: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirA[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 1: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirB[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 2: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirC[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 3: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirD[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 4: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirE[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 5: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirF[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 6: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirG[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 7: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirH[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 8: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirI[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 9: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirJ[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 10: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirK[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 11: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirL[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            case 12: {
                i = 0;
                while (i < 36) {
                    this.wiringMaze[i] = (byte)(wirM[i] - 1);
                    this.inversMaze[this.wiringMaze[i]] = (byte)i;
                    ++i;
                }
                break;
            }
            default: {
                System.out.println("PROBLEM Initializing a new Rotor \"" + this.name + "\"");
                System.exit(-1);
            }
        }
    }

    public Rotor(String rotorID) {
        this.name = rotorID;
        if (rNamInd.indexOf(rotorID) == -1) {
            System.err.println("Rotor(" + rotorID + ") ERROR: " + "wrong name! must be [A-M]");
            System.exit(-3);
        }
        this.setWiringMaze(this.convIDtoNum(rotorID));
        this.winPos = 0;
        this.startPos = 0;
    }

    public Rotor(int index) {
        this.name = rName[index];
        this.setWiringMaze(index);
        this.winPos = 0;
        this.startPos = 0;
    }

    public Rotor(String rotorID, String custom) {
        int i = 0;
        int k = 0;
        if (rNamInd.indexOf(rotorID) == -1) {
            System.err.println("Rotor(" + rotorID + ") ERROR: " + "wrong name! must be [A-M]");
            System.exit(-3);
        }
        if (custom.length() != 36) {
            System.err.println("Rotor(" + rotorID + ") ERROR: " + "wrong input string length (got " + custom.length() + " instead of 36");
            System.exit(-3);
        }
        this.name = rotorID;
        this.wiringMaze = new byte[37];
        this.inversMaze = new byte[256];
        this.ringRevMark = new byte[256];
        i = 0;
        while (i < 256) {
            this.ringRevMark[i] = -1;
            this.inversMaze[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 36) {
            this.wiringMaze[i] = -1;
            if (ringLetterMark[i] != 32) {
                this.ringRevMark[Rotor.ringLetterMark[i]] = (byte)i;
            }
            ++i;
        }
        i = 0;
        while (i < 36) {
            if (this.wiringMaze[i] != -1) {
                System.err.println("Rotor(" + rotorID + ") ERROR: " + "duplicate entry at index " + (i + 1) + " cust: '" + custom.charAt(i) + "' wir: " + this.wiringMaze[i]);
                System.exit(-3);
            }
            if ((k = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".indexOf(custom.charAt(i))) < 0 || k > 35) {
                System.err.println("Rotor(" + rotorID + ") ERROR: " + "invalid entry at index " + (i + 1) + " " + custom.charAt(i));
                System.exit(-4);
            }
            this.wiringMaze[i] = (byte)(k & 0xFF);
            this.inversMaze[this.wiringMaze[i]] = (byte)i;
            ++i;
        }
        this.winPos = 0;
        this.startPos = 0;
        if (!this.validateRotor(this.wiringMaze)) {
            System.err.println("Rotor(" + this.name + ", custom) failed validation!");
        }
    }

    public boolean validateRotor(byte[] custom) {
        int i = 0;
        byte[] check = new byte[36];
        if (custom.length < 36) {
            System.err.println("validateRotor(): wrong length of wiringMaze: " + custom.length + " instead of 36");
            return false;
        }
        i = 0;
        while (i < 36) {
            check[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 36) {
            if (custom[i] > 35 || custom[i] < 0) {
                System.err.println("ERROR: invalid entry at position " + (i + 1) + " (1..36): " + custom[i]);
                return false;
            }
            if (check[i] != -1) {
                System.err.println("validateRotor(): duplication at index " + i);
                return false;
            }
            check[i] = custom[i];
            ++i;
        }
        return true;
    }

    public boolean validateThisRotor() {
        return this.validateRotor(this.wiringMaze);
    }

    String getName() {
        return this.name;
    }

    byte getRotorPos() {
        return this.startPos;
    }

    void setRotorPos(byte r) {
        this.startPos = r;
        if (r < 0 || r >= 36) {
            this.startPos = 0;
        }
        this.winPos = 0;
    }

    int getCurPos() {
        return this.winPos;
    }

    char getWinPos() {
        return (char)ringLetterMark[this.winPos];
    }

    char getCharAtPos(int index) {
        char ch = (char)ringLetterMark[index % 36];
        return ch;
    }

    char[] getFullWinPos() {
        char[] win = new char[3];
        int i = 0;
        while (i < 3) {
            int ch = ringLetterMark[(this.winPos + i) % 36];
            if (ch == -1) {
                ch = 32;
            }
            win[i] = (char)ch;
            ++i;
        }
        return win;
    }

    void setWinPos(byte pos) {
        this.winPos = (byte)(pos % 36);
    }

    void setWinAPos(char pos) {
        this.winPos = (byte)(this.ringRevMark[pos] % 36);
    }

    void stepRotor() {
        this.winPos = (byte)((this.winPos + 1) % 36);
    }

    byte encode(byte sym) {
        byte out = 0;
        byte index = (byte)((sym + this.winPos + this.startPos) % 36);
        out = (byte)((this.wiringMaze[index] + 72 - this.startPos - this.winPos) % 36);
        return out;
    }

    byte decode(byte sym) {
        byte out = 0;
        byte index = (byte)((sym + this.winPos + this.startPos) % 36);
        out = (byte)((this.inversMaze[index] + 72 - this.startPos - this.winPos) % 36);
        return out;
    }

    public void dumpRotor() {
        System.out.println("Rotor \"" + this.name + "\"");
        int i = 0;
        while (i < 36) {
            System.out.format("%02d-%02d\n", i + 1, this.wiringMaze[i] + 1);
            ++i;
        }
    }

    public void testRotor() {
        int i = 0;
        int j = 0;
        i = 0;
        while (i < 35) {
            j = i + 1;
            while (j < 36) {
                if (this.wiringMaze[i] == this.wiringMaze[j]) {
                    System.out.println("Rotor \"" + this.name + "\" BIG problem at indexes " + i + " and " + j);
                }
                ++j;
            }
            ++i;
        }
    }
}

