/*
 * Decompiled with CFR 0.152.
 */
package kl7;

import java.io.Serializable;
import kl7.Box;
import kl7.BoxMode;
import kl7.Register;

public class SavedState
implements Serializable {
    private static final long serialVersionUID = 1734596279626943898L;
    private String[] rotors = new String[8];
    private int[] lpos = new int[8];
    private int[] nrings = new int[7];
    private int[] nrpos = new int[7];
    private byte[] curpos = new byte[8];
    private int[] msgKey = new int[7];
    private Register bReg;
    private BoxMode bM;
    private int cntr;
    private Box b;

    public static void main(String[] args) {
        SavedState sst = new SavedState(new Box());
        System.out.println("About to save Box state...");
        sst.b.dumpBox();
        sst.saveState();
        sst.dumpState();
        System.out.println("About to restore Box state, reducing L-offset by 1...");
        sst.lpos[3] = (sst.lpos[3] + 36 - 1) % 36;
        sst.restoreState();
        sst.b.dumpBox();
    }

    public SavedState() {
    }

    public SavedState(Box b) {
        this();
        this.b = b;
    }

    public void saveState() {
        int i = 0;
        while (i < 8) {
            this.rotors[i] = this.b.getRotor(i);
            this.lpos[i] = this.b.getRotorStart(i);
            this.curpos[i] = (byte)this.b.cage.rotors[i].getCurPos();
            if (i != 7) {
                this.nrings[i] = this.b.getNRing(i);
                this.nrpos[i] = this.b.getNRingPos(i);
            }
            ++i;
        }
        this.msgKey = this.b.getIntKey();
        this.bReg = this.b.getReg();
        this.bM = this.b.getBoxMode();
        this.cntr = this.b.getCounter();
    }

    public void restoreState() {
        int i = 0;
        while (i < 8) {
            this.b.setRotor(this.rotors[i], i);
            this.b.setRotorStart(i, (byte)this.lpos[i]);
            if (i != 7) {
                this.b.setNRing(i, this.nrings[i] - 1);
                this.b.setNRingPos(i, this.nrpos[i]);
            }
            ++i;
        }
        this.b.setMsgKey(this.msgKey);
        this.b.setBoxMode(this.bM);
        this.b.setReg(this.bReg);
        this.b.counter = this.cntr;
        i = 0;
        while (i < 8) {
            this.b.cage.rotors[i].setWinPos(this.curpos[i]);
            ++i;
        }
    }

    public void changeBox(Box b) {
        this.b = b;
    }

    public void dumpState() {
        System.out.println("Box mode: " + (Object)((Object)this.bM) + "  Register: " + (Object)((Object)this.bReg));
        System.out.println("Rotors: \t");
        int i = 0;
        while (i < 8) {
            System.out.print(String.valueOf(this.rotors[i]) + "-" + String.format("%02d ", this.lpos[i]));
            ++i;
        }
        System.out.println();
        System.out.print("N-Rings: \t");
        i = 0;
        while (i < 7) {
            System.out.print(String.valueOf(String.format("%1d", this.nrings[i])) + "-" + String.format("%02d ", this.nrpos[i]));
            ++i;
        }
        System.out.println();
        System.out.print("Msg key:\t");
        i = 0;
        while (i < 7) {
            System.out.print(String.valueOf(this.msgKey[i]) + " ");
            ++i;
        }
        System.out.println();
    }
}

